/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.examples.WindowUtils;
import com.sun.jna.examples.unix.X11;
import com.sun.jna.examples.win32.GDI32;
import com.sun.jna.examples.win32.User32;
import com.sun.jna.examples.win32.W32API;
import com.sun.jna.ptr.PointerByReference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class AlphaMaskDemo
implements Runnable {
    private static final DataFlavor URL_FLAVOR = new DataFlavor("application/x-java-url; class=java.net.URL", "URL");
    private static final DataFlavor URI_LIST_FLAVOR = new DataFlavor("text/uri-list; class=java.lang.String", "URI list");
    private JFrame frame;
    private JWindow alphaWindow;
    private float alpha = 1.0f;
    private Image image;
    private Memory buffer;
    private int[] pixels;
    private ImageObserver observer = new ImageObserver(){

        public boolean imageUpdate(final Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x30) != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AlphaMaskDemo.this.setImage(img);
                    }
                });
                return false;
            }
            if ((infoflags & 0xC0) != 0) {
                System.out.println("Image load error: " + img);
                return false;
            }
            return true;
        }
    };

    private void update() {
        this.update(false, true);
    }

    private void update(boolean a, boolean i) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            this.updateW32(a, i);
        } else if (os.startsWith("Linux")) {
            this.updateX11(a, i);
        } else if (os.startsWith("Mac")) {
            this.updateMac(a, i);
        }
    }

    private void updateMac(boolean a, boolean i) {
        if (!this.alphaWindow.isDisplayable()) {
            this.alphaWindow.pack();
        }
        if (a) {
            WindowUtils.setWindowAlpha(this.alphaWindow, this.alpha);
        }
        if (i) {
            this.alphaWindow.setBackground(new Color(0, 0, 0, 0));
            this.alphaWindow.setContentPane(new JLabel(new ImageIcon(this.image)));
            this.alphaWindow.setSize(this.alphaWindow.getPreferredSize());
        }
        if (!this.alphaWindow.isVisible()) {
            Window parent = this.alphaWindow.getOwner();
            Point where = parent.getLocationOnScreen();
            where.translate(parent.getWidth(), 0);
            this.alphaWindow.setLocation(where);
            this.alphaWindow.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateX11(boolean a, boolean i) {
        block16: {
            X11 x11 = X11.INSTANCE;
            X11.Window win = X11.Window.None;
            X11.Display dpy = x11.XOpenDisplay(null);
            try {
                if (!this.alphaWindow.isDisplayable()) {
                    this.alphaWindow.pack();
                    if (System.getProperty("java.version").matches("^1\\.4\\..*")) {
                        this.alphaWindow.setVisible(true);
                    }
                    win = new X11.Window((int)Native.getWindowID((Window)this.alphaWindow));
                    Window parent = this.alphaWindow.getOwner();
                    Point where = parent.getLocationOnScreen();
                    where.translate(parent.getWidth(), 0);
                    this.alphaWindow.removeAll();
                    this.alphaWindow.setLocation(where);
                    this.alphaWindow.setBackground(new Color(0, 0, 0, 0));
                } else {
                    win = new X11.Window((int)Native.getWindowID((Window)this.alphaWindow));
                }
                if (!i) break block16;
                int w = this.image.getWidth(null);
                int h = this.image.getHeight(null);
                this.alphaWindow.setSize(w, h);
                if (this.buffer == null || this.buffer.getSize() != (long)(w * h * 4)) {
                    this.buffer = new Memory((long)(w * h * 4));
                    this.pixels = new int[w * h];
                }
                BufferedImage buf = new BufferedImage(w, h, 3);
                Graphics g = buf.getGraphics();
                g.drawImage(this.image, 0, 0, w, h, null);
                long start = System.currentTimeMillis();
                X11.GC gc = x11.XCreateGC(dpy, win, new NativeLong(0L), null);
                long gcTime = System.currentTimeMillis();
                try {
                    Raster raster = buf.getData();
                    int[] pixel = new int[4];
                    for (int y = 0; y < h; ++y) {
                        for (int x = 0; x < w; ++x) {
                            raster.getPixel(x, y, pixel);
                            int alpha = (pixel[3] & 0xFF) << 24;
                            int red = pixel[2] & 0xFF;
                            int green = (pixel[1] & 0xFF) << 8;
                            int blue = (pixel[0] & 0xFF) << 16;
                            this.pixels[y * w + x] = alpha | red | green | blue;
                        }
                    }
                    long blitTime = System.currentTimeMillis();
                    X11.XWindowAttributes xwa = new X11.XWindowAttributes();
                    x11.XGetWindowAttributes(dpy, win, xwa);
                    X11.XImage image = x11.XCreateImage(dpy, xwa.visual, 32, 2, 0, (Pointer)this.buffer, w, h, 32, w * 4);
                    this.buffer.write(0L, this.pixels, 0, this.pixels.length);
                    long write = System.currentTimeMillis();
                    x11.XPutImage(dpy, win, gc, image, 0, 0, 0, 0, w, h);
                    x11.XFree(image.getPointer());
                    long putImageTime = System.currentTimeMillis();
                }
                finally {
                    if (gc != null) {
                        x11.XFreeGC(dpy, gc);
                    }
                }
                long end = System.currentTimeMillis();
            }
            finally {
                if (dpy != null) {
                    x11.XCloseDisplay(dpy);
                }
            }
        }
        if (a) {
            WindowUtils.setWindowAlpha(this.alphaWindow, this.alpha);
        }
        if (!this.alphaWindow.isVisible()) {
            this.alphaWindow.setVisible(true);
            this.update(true, true);
        }
    }

    private W32API.HWND getHwnd(Window w) {
        W32API.HWND hwnd = new W32API.HWND();
        hwnd.setPointer(Native.getWindowPointer((Window)w));
        return hwnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateW32(boolean a, boolean i) {
        block11: {
            W32API.HWND hWnd;
            User32 user;
            block10: {
                user = User32.INSTANCE;
                GDI32 gdi = GDI32.INSTANCE;
                hWnd = null;
                if (!this.alphaWindow.isDisplayable()) {
                    this.alphaWindow.pack();
                    hWnd = this.getHwnd(this.alphaWindow);
                    int flags = user.GetWindowLong(hWnd, -20);
                    user.SetWindowLong(hWnd, -20, flags |= 0x80000);
                    Window parent = this.alphaWindow.getOwner();
                    Point where = parent.getLocationOnScreen();
                    where.translate(parent.getWidth(), 0);
                    this.alphaWindow.setLocation(where);
                } else {
                    hWnd = this.getHwnd(this.alphaWindow);
                }
                if (!i) break block10;
                int w = this.image.getWidth(null);
                int h = this.image.getHeight(null);
                W32API.HDC screenDC = user.GetDC(null);
                W32API.HDC memDC = gdi.CreateCompatibleDC(screenDC);
                W32API.HBITMAP hBitmap = null;
                W32API.HANDLE oldBitmap = null;
                try {
                    BufferedImage buf = new BufferedImage(w, h, 3);
                    Graphics g = buf.getGraphics();
                    g.drawImage(this.image, 0, 0, w, h, null);
                    GDI32.BITMAPINFO bmi = new GDI32.BITMAPINFO();
                    bmi.bmiHeader.biWidth = w;
                    bmi.bmiHeader.biHeight = h;
                    bmi.bmiHeader.biPlanes = 1;
                    bmi.bmiHeader.biBitCount = (short)32;
                    bmi.bmiHeader.biCompression = 0;
                    bmi.bmiHeader.biSizeImage = w * h * 4;
                    PointerByReference ppbits = new PointerByReference();
                    hBitmap = gdi.CreateDIBSection(memDC, bmi, 0, ppbits, null, 0);
                    oldBitmap = gdi.SelectObject(memDC, hBitmap);
                    Pointer pbits = ppbits.getValue();
                    Raster raster = buf.getData();
                    int[] pixel = new int[4];
                    int[] bits = new int[w * h];
                    for (int y = 0; y < h; ++y) {
                        for (int x = 0; x < w; ++x) {
                            raster.getPixel(x, h - y - 1, pixel);
                            int alpha = (pixel[3] & 0xFF) << 24;
                            int red = pixel[2] & 0xFF;
                            int green = (pixel[1] & 0xFF) << 8;
                            int blue = (pixel[0] & 0xFF) << 16;
                            bits[x + y * w] = alpha | red | green | blue;
                        }
                    }
                    pbits.write(0L, bits, 0, bits.length);
                    User32.SIZE size = new User32.SIZE();
                    size.cx = w;
                    size.cy = h;
                    User32.POINT loc = new User32.POINT();
                    loc.x = this.alphaWindow.getX();
                    loc.y = this.alphaWindow.getY();
                    User32.POINT srcLoc = new User32.POINT();
                    User32.BLENDFUNCTION blend = new User32.BLENDFUNCTION();
                    blend.SourceConstantAlpha = (byte)(this.alpha * 255.0f);
                    blend.AlphaFormat = 1;
                    user.UpdateLayeredWindow(hWnd, screenDC, loc, size, memDC, srcLoc, 0, blend, 2);
                    user.ReleaseDC(null, screenDC);
                }
                catch (Throwable throwable) {
                    user.ReleaseDC(null, screenDC);
                    if (hBitmap != null) {
                        gdi.SelectObject(memDC, oldBitmap);
                        gdi.DeleteObject(hBitmap);
                    }
                    gdi.DeleteDC(memDC);
                    throw throwable;
                }
                if (hBitmap != null) {
                    gdi.SelectObject(memDC, oldBitmap);
                    gdi.DeleteObject(hBitmap);
                }
                gdi.DeleteDC(memDC);
                break block11;
            }
            if (a) {
                User32.BLENDFUNCTION blend = new User32.BLENDFUNCTION();
                blend.SourceConstantAlpha = (byte)(this.alpha * 255.0f);
                blend.AlphaFormat = 1;
                user.UpdateLayeredWindow(hWnd, null, null, null, null, null, 0, blend, 2);
            }
        }
        if (!this.alphaWindow.isVisible()) {
            this.alphaWindow.setVisible(true);
        }
    }

    private void setImage(Image image) {
        int w = image.getWidth(this.observer);
        int h = image.getHeight(this.observer);
        if (w > 0 && h > 0) {
            this.image = image;
            this.frame.setIconImage(image);
            this.update(false, true);
        }
    }

    private void setAlpha(float alpha) {
        this.alpha = alpha = Math.min(1.0f, Math.max(0.0f, alpha));
        this.update(true, false);
    }

    public void run() {
        GraphicsConfiguration gconfig = WindowUtils.getAlphaCompatibleGraphicsConfiguration();
        this.frame = new JFrame("Alpha Mask Demo");
        this.alphaWindow = new JWindow(this.frame, gconfig);
        MouseInputAdapter handler = new MouseInputAdapter(){
            private Point offset;

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    this.offset = e.getPoint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                this.offset = null;
                if (System.getProperty("os.name").startsWith("Windows")) {
                    AlphaMaskDemo.this.update(true, true);
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (this.offset != null) {
                    Window w = (Window)e.getSource();
                    Point where = e.getPoint();
                    where.translate(-this.offset.x, -this.offset.y);
                    Point loc = w.getLocationOnScreen();
                    loc.translate(where.x, where.y);
                    w.setLocation(loc.x, loc.y);
                }
            }
        };
        this.alphaWindow.addMouseListener(handler);
        this.alphaWindow.addMouseMotionListener(handler);
        JPanel p = new JPanel(new BorderLayout(8, 8));
        p.setBorder(new EmptyBorder(8, 8, 8, 8));
        p.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                List<DataFlavor> list = Arrays.asList(transferFlavors);
                if (list.contains(URL_FLAVOR) || list.contains(URI_LIST_FLAVOR) || list.contains(DataFlavor.imageFlavor) || list.contains(DataFlavor.javaFileListFlavor)) {
                    return true;
                }
                if (DataFlavor.selectBestTextFlavor(transferFlavors) != null) {
                    return true;
                }
                System.out.println("No acceptable flavor found in " + Arrays.asList(transferFlavors));
                return false;
            }

            public boolean importData(JComponent comp, Transferable t) {
                try {
                    if (t.isDataFlavorSupported(URL_FLAVOR)) {
                        URL url = (URL)t.getTransferData(URL_FLAVOR);
                        AlphaMaskDemo.this.setImage(Toolkit.getDefaultToolkit().getImage(url));
                        return true;
                    }
                    if (t.isDataFlavorSupported(URI_LIST_FLAVOR)) {
                        String s = (String)t.getTransferData(URI_LIST_FLAVOR);
                        String[] uris = s.split("[\r\n]");
                        if (uris.length > 0) {
                            URL url = new URL(uris[0]);
                            AlphaMaskDemo.this.setImage(Toolkit.getDefaultToolkit().getImage(url));
                            return true;
                        }
                        return false;
                    }
                    if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                        AlphaMaskDemo.this.setImage(image);
                        return true;
                    }
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        File f = (File)files.get(0);
                        URL url = new URL("file://" + f.toURI().toURL().getPath());
                        Image image = Toolkit.getDefaultToolkit().getImage(url);
                        AlphaMaskDemo.this.setImage(image);
                        return true;
                    }
                    DataFlavor flavor = DataFlavor.selectBestTextFlavor(t.getTransferDataFlavors());
                    if (flavor != null) {
                        int count;
                        Reader reader = flavor.getReaderForText(t);
                        char[] buf = new char[512];
                        StringBuffer b = new StringBuffer();
                        while ((count = reader.read(buf)) > 0) {
                            for (int i = 0; i < count; ++i) {
                                if (buf[i] == '\u0000') continue;
                                b.append(buf, i, 1);
                            }
                        }
                        String html = b.toString();
                        Pattern p = Pattern.compile("<img.*src=\"([^\\\"\">]+)\"", 192);
                        Matcher m = p.matcher(html);
                        if (m.find()) {
                            URL url = new URL(m.group(1));
                            System.out.println("Load image from " + url);
                            Image image = Toolkit.getDefaultToolkit().getImage(url);
                            AlphaMaskDemo.this.setImage(image);
                            return true;
                        }
                        System.out.println("Can't parse text: " + html);
                        return false;
                    }
                    System.out.println("No flavor available: " + Arrays.asList(t.getTransferDataFlavors()));
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        p.add((Component)new JLabel("<html><center>Drop an image with an alpha channel onto this window<br>You may also adjust the overall transparency with the slider</center></html>"), "North");
        final JSlider slider = new JSlider(0, 255, 255);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = slider.getValue();
                AlphaMaskDemo.this.setAlpha((float)value / 255.0f);
            }
        });
        p.add((Component)slider, "South");
        this.frame.getContentPane().add(p);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        AlphaMaskDemo.centerOnScreen(this.frame);
        this.frame.setVisible(true);
        p.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AlphaMaskDemo.this.update();
            }
        });
        try {
            URL url = this.getClass().getResource("tardis.png");
            if (url != null) {
                this.setImage(Toolkit.getDefaultToolkit().getImage(url));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void centerOnScreen(Window window) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Rectangle max = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int x = Math.max(center.x - Math.round((float)window.getWidth() / 2.0f), max.x);
        int y = Math.max(center.y - Math.round((float)window.getHeight() / 2.0f), max.y);
        window.setLocation(new Point(x, y));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new AlphaMaskDemo());
    }
}

