/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.examples.win32.Shell32;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public abstract class FileUtils {
    public boolean hasTrash() {
        return false;
    }

    public abstract void moveToTrash(File[] var1) throws IOException;

    public static FileUtils getInstance() {
        return Holder.INSTANCE;
    }

    private static class DefaultFileUtils
    extends FileUtils {
        private DefaultFileUtils() {
        }

        private File getTrashDirectory() {
            File desktop;
            File home = new File(System.getProperty("user.home"));
            File trash = new File(home, ".Trash");
            if (!(trash.exists() || (trash = new File(home, "Trash")).exists() || !(desktop = new File(home, "Desktop")).exists() || (trash = new File(desktop, ".Trash")).exists() || (trash = new File(desktop, "Trash")).exists())) {
                trash = new File(System.getProperty("fileutils.trash", "Trash"));
            }
            return trash;
        }

        public boolean hasTrash() {
            return this.getTrashDirectory().exists();
        }

        public void moveToTrash(File[] files) throws IOException {
            File trash = this.getTrashDirectory();
            if (!trash.exists()) {
                throw new IOException("No trash location found (define fileutils.trash to be the path to the trash)");
            }
            ArrayList<File> failed = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File src = files[i];
                File target = new File(trash, src.getName());
                if (src.renameTo(target)) continue;
                failed.add(src);
            }
            if (failed.size() > 0) {
                throw new IOException("The following files could not be trashed: " + failed);
            }
        }
    }

    private static class MacFileUtils
    extends FileUtils {
        private MacFileUtils() {
        }

        public boolean hasTrash() {
            return true;
        }

        public void moveToTrash(File[] files) throws IOException {
            File home = new File(System.getProperty("user.home"));
            File trash = new File(home, ".Trash");
            if (!trash.exists()) {
                throw new IOException("The Trash was not found in its expected location (" + trash + ")");
            }
            ArrayList<File> failed = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File src = files[i];
                File target = new File(trash, src.getName());
                if (src.renameTo(target)) continue;
                failed.add(src);
            }
            if (failed.size() > 0) {
                throw new IOException("The following files could not be trashed: " + failed);
            }
        }
    }

    private static class W32FileUtils
    extends FileUtils {
        private W32FileUtils() {
        }

        public boolean hasTrash() {
            return true;
        }

        public void moveToTrash(File[] files) throws IOException {
            Shell32 shell = Shell32.INSTANCE;
            Shell32.SHFILEOPSTRUCT fileop = new Shell32.SHFILEOPSTRUCT();
            fileop.wFunc = 3;
            String[] paths = new String[files.length];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = files[i].getAbsolutePath();
            }
            fileop.pFrom = fileop.encodePaths(paths);
            fileop.fFlags = (short)84;
            int ret = shell.SHFileOperation(fileop);
            if (ret != 0) {
                throw new IOException("Move to trash failed: " + ret);
            }
            if (fileop.fAnyOperationsAborted) {
                throw new IOException("Move to trash aborted");
            }
        }
    }

    private static class Holder {
        public static final FileUtils INSTANCE;

        private Holder() {
        }

        static {
            String os = System.getProperty("os.name");
            INSTANCE = os.startsWith("Windows") ? new W32FileUtils() : (os.startsWith("Mac") ? new MacFileUtils() : new DefaultFileUtils());
        }
    }
}

