/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.artemis.sdk.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger Logger = LoggerFactory.getLogger(StringUtils.class);

    public static String sign(String secret, String method, String path, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys, List<String> signHeaderPrefixList) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            byte[] keyBytes = secret.getBytes("UTF-8");
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256"));
            String stringToSign = SignUtil.buildStringToSign(method, path, headers, querys, bodys, signHeaderPrefixList);
            if (Logger.isDebugEnabled()) {
                Logger.debug("StringToSign:\n{}", (Object)stringToSign);
            }
            return new String(Base64.encodeBase64((byte[])hmacSha256.doFinal(stringToSign.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildStringToSign(String method, String path, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys, List<String> signHeaderPrefixList) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase()).append("\n");
        if (null != headers) {
            if (null != headers.get("Accept")) {
                sb.append(headers.get("Accept"));
                sb.append("\n");
            }
            if (null != headers.get("Content-MD5")) {
                sb.append(headers.get("Content-MD5"));
                sb.append("\n");
            }
            if (null != headers.get("Content-Type")) {
                String contentType = headers.get("Content-Type");
                if (contentType.contains("boundary")) {
                    String[] strings;
                    for (String string : strings = contentType.split(";")) {
                        if (string.contains("boundary")) continue;
                        sb.append(string);
                        sb.append(";");
                    }
                    sb.deleteCharAt(sb.toString().length() - 1);
                } else {
                    sb.append(contentType);
                }
                sb.append("\n");
            }
            if (null != headers.get("Date")) {
                sb.append(headers.get("Date"));
                sb.append("\n");
            }
        }
        sb.append(SignUtil.buildHeaders(headers, signHeaderPrefixList));
        sb.append(SignUtil.buildResource(path, querys, bodys));
        return sb.toString();
    }

    private static String buildResource(String path, Map<String, String> querys, Map<String, String> bodys) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)path)) {
            sb.append(path);
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        if (null != querys) {
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sortMap.put(query.getKey(), query.getValue());
            }
        }
        if (null != bodys) {
            for (Map.Entry<String, String> body : bodys.entrySet()) {
                if (StringUtils.isBlank((CharSequence)body.getKey())) continue;
                sortMap.put(body.getKey(), body.getValue());
            }
        }
        StringBuilder sbParam = new StringBuilder();
        for (Map.Entry item : sortMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)item.getKey()))) continue;
            if (0 < sbParam.length()) {
                sbParam.append("&");
            }
            sbParam.append((String)item.getKey());
            if (StringUtils.isBlank((CharSequence)((CharSequence)item.getValue()))) continue;
            sbParam.append("=").append((String)item.getValue());
        }
        if (0 < sbParam.length()) {
            sb.append("?");
            sb.append((CharSequence)sbParam);
        }
        return sb.toString();
    }

    private static String buildHeaders(Map<String, String> headers, List<String> signHeaderPrefixList) {
        StringBuilder sb = new StringBuilder();
        if (null != signHeaderPrefixList) {
            signHeaderPrefixList.remove("x-ca-signature");
            signHeaderPrefixList.remove("Accept");
            signHeaderPrefixList.remove("Content-MD5");
            signHeaderPrefixList.remove("Content-Type");
            signHeaderPrefixList.remove("Date");
            Collections.sort(signHeaderPrefixList);
        }
        if (null != headers) {
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            sortMap.putAll(headers);
            StringBuilder signHeadersStringBuilder = new StringBuilder();
            for (Map.Entry header : sortMap.entrySet()) {
                if (!SignUtil.isHeaderToSign((String)header.getKey(), signHeaderPrefixList)) continue;
                sb.append((String)header.getKey());
                sb.append(":");
                if (!StringUtils.isBlank((CharSequence)((CharSequence)header.getValue()))) {
                    sb.append((String)header.getValue());
                }
                sb.append("\n");
                if (0 < signHeadersStringBuilder.length()) {
                    signHeadersStringBuilder.append(",");
                }
                signHeadersStringBuilder.append((String)header.getKey());
            }
            headers.put("x-ca-signature-headers", signHeadersStringBuilder.toString());
        }
        return sb.toString();
    }

    private static boolean isHeaderToSign(String headerName, List<String> signHeaderPrefixList) {
        if (StringUtils.isBlank((CharSequence)headerName)) {
            return false;
        }
        if (headerName.startsWith("x-ca-")) {
            return true;
        }
        if (null != signHeaderPrefixList) {
            for (String signHeaderPrefix : signHeaderPrefixList) {
                if (!headerName.equalsIgnoreCase(signHeaderPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

