/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.transform.SecuritySupport;
import javax.xml.transform.TransformerFactoryConfigurationError;

class FactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xalan.internal.";
    private static boolean debug = false;
    private static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;
    private static final SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Class<?> getProviderClass(String string, ClassLoader classLoader, boolean bl, boolean bl2) throws ClassNotFoundException {
        try {
            if (classLoader == null) {
                if (bl2) {
                    return Class.forName(string, false, FactoryFinder.class.getClassLoader());
                }
                classLoader = ss.getContextClassLoader();
                if (classLoader == null) {
                    throw new ClassNotFoundException();
                }
                return Class.forName(string, false, classLoader);
            }
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                return Class.forName(string, false, FactoryFinder.class.getClassLoader());
            }
            throw classNotFoundException;
        }
    }

    static <T> T newInstance(Class<T> clazz, String string, ClassLoader classLoader, boolean bl, boolean bl2) throws TransformerFactoryConfigurationError {
        assert (clazz != null);
        boolean bl3 = false;
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            classLoader = null;
            bl3 = true;
        }
        try {
            Class<?> clazz2 = FactoryFinder.getProviderClass(string, classLoader, bl, bl3);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ClassCastException(string + " cannot be cast to " + clazz.getName());
            }
            Object var7_9 = null;
            if (!bl2) {
                var7_9 = FactoryFinder.newInstanceNoServiceLoader(clazz, clazz2);
            }
            if (var7_9 == null) {
                var7_9 = clazz2.newInstance();
            }
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + clazz2 + " using ClassLoader: " + classLoader);
            }
            return clazz.cast(var7_9);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerFactoryConfigurationError(classNotFoundException, "Provider " + string + " not found");
        }
        catch (Exception exception) {
            throw new TransformerFactoryConfigurationError(exception, "Provider " + string + " could not be instantiated: " + exception);
        }
    }

    private static <T> T newInstanceNoServiceLoader(Class<T> clazz, Class<?> clazz2) {
        if (System.getSecurityManager() == null) {
            return null;
        }
        try {
            Method method = clazz2.getDeclaredMethod("newTransformerFactoryNoServiceLoader", new Class[0]);
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) {
                return null;
            }
            Class<?> clazz3 = method.getReturnType();
            if (clazz.isAssignableFrom(clazz3)) {
                Object object = method.invoke(null, (Object[])null);
                return clazz.cast(object);
            }
            throw new ClassCastException(clazz3 + " cannot be cast to " + clazz);
        }
        catch (ClassCastException classCastException) {
            throw new TransformerFactoryConfigurationError(classCastException, classCastException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T find(Class<T> clazz, String string) throws TransformerFactoryConfigurationError {
        Object object;
        String string2;
        block16: {
            block15: {
                assert (clazz != null);
                string2 = clazz.getName();
                FactoryFinder.dPrint("find factoryId =" + string2);
                try {
                    object = ss.getSystemProperty(string2);
                    if (object != null) {
                        FactoryFinder.dPrint("found system property, value=" + (String)object);
                        return FactoryFinder.newInstance(clazz, (String)object, null, true, true);
                    }
                }
                catch (SecurityException securityException) {
                    if (!debug) break block15;
                    securityException.printStackTrace();
                }
            }
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            String string3 = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                            File file = new File(string3);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                FactoryFinder.dPrint("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            }
                        }
                    }
                }
                if ((object = cacheProps.getProperty(string2)) != null) {
                    FactoryFinder.dPrint("found in $java.home/jaxp.properties, value=" + (String)object);
                    return FactoryFinder.newInstance(clazz, (String)object, null, true, true);
                }
            }
            catch (Exception exception) {
                if (!debug) break block16;
                exception.printStackTrace();
            }
        }
        if ((object = FactoryFinder.findServiceProvider(clazz)) != null) {
            return (T)object;
        }
        if (string == null) {
            throw new TransformerFactoryConfigurationError(null, "Provider for " + string2 + " cannot be found");
        }
        FactoryFinder.dPrint("loaded from fallback value: " + string);
        return FactoryFinder.newInstance(clazz, string, null, true, true);
    }

    private static <T> T findServiceProvider(final Class<T> clazz) throws TransformerFactoryConfigurationError {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    ServiceLoader serviceLoader = ServiceLoader.load(clazz);
                    Iterator iterator = serviceLoader.iterator();
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            RuntimeException runtimeException = new RuntimeException("Provider for " + clazz + " cannot be created", serviceConfigurationError);
            TransformerFactoryConfigurationError transformerFactoryConfigurationError = new TransformerFactoryConfigurationError(runtimeException, runtimeException.getMessage());
            throw transformerFactoryConfigurationError;
        }
    }

    static {
        try {
            String string = ss.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }
}

