/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer.stax;

import com.sun.xml.internal.org.jvnet.staxex.Base64Data;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.stax.StreamBufferCreator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StreamReaderBufferCreator
extends StreamBufferCreator {
    private int _eventType;
    private boolean _storeInScopeNamespacesOnElementFragment;
    private Map<String, Integer> _inScopePrefixes;

    public StreamReaderBufferCreator() {
    }

    public StreamReaderBufferCreator(MutableXMLStreamBuffer mutableXMLStreamBuffer) {
        this.setBuffer(mutableXMLStreamBuffer);
    }

    public MutableXMLStreamBuffer create(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (this._buffer == null) {
            this.createBuffer();
        }
        this.store(xMLStreamReader);
        return this.getXMLStreamBuffer();
    }

    public MutableXMLStreamBuffer createElementFragment(XMLStreamReader xMLStreamReader, boolean bl) throws XMLStreamException {
        if (this._buffer == null) {
            this.createBuffer();
        }
        if (!xMLStreamReader.hasNext()) {
            return this._buffer;
        }
        this._storeInScopeNamespacesOnElementFragment = bl;
        this._eventType = xMLStreamReader.getEventType();
        if (this._eventType != 1) {
            do {
                this._eventType = xMLStreamReader.next();
            } while (this._eventType != 1 && this._eventType != 8);
        }
        if (bl) {
            this._inScopePrefixes = new HashMap<String, Integer>();
        }
        this.storeElementAndChildren(xMLStreamReader);
        return this.getXMLStreamBuffer();
    }

    private void store(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (!xMLStreamReader.hasNext()) {
            return;
        }
        this._eventType = xMLStreamReader.getEventType();
        switch (this._eventType) {
            case 7: {
                this.storeDocumentAndChildren(xMLStreamReader);
                break;
            }
            case 1: {
                this.storeElementAndChildren(xMLStreamReader);
                break;
            }
            default: {
                throw new XMLStreamException("XMLStreamReader not positioned at a document or element");
            }
        }
        this.increaseTreeCount();
    }

    private void storeDocumentAndChildren(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.storeStructure(16);
        this._eventType = xMLStreamReader.next();
        block5: while (this._eventType != 8) {
            switch (this._eventType) {
                case 1: {
                    this.storeElementAndChildren(xMLStreamReader);
                    continue block5;
                }
                case 5: {
                    this.storeComment(xMLStreamReader);
                    break;
                }
                case 3: {
                    this.storeProcessingInstruction(xMLStreamReader);
                }
            }
            this._eventType = xMLStreamReader.next();
        }
        this.storeStructure(144);
    }

    private void storeElementAndChildren(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (xMLStreamReader instanceof XMLStreamReaderEx) {
            this.storeElementAndChildrenEx((XMLStreamReaderEx)xMLStreamReader);
        } else {
            this.storeElementAndChildrenNoEx(xMLStreamReader);
        }
    }

    private void storeElementAndChildrenEx(XMLStreamReaderEx xMLStreamReaderEx) throws XMLStreamException {
        int n = 1;
        if (this._storeInScopeNamespacesOnElementFragment) {
            this.storeElementWithInScopeNamespaces((XMLStreamReader)xMLStreamReaderEx);
        } else {
            this.storeElement((XMLStreamReader)xMLStreamReaderEx);
        }
        while (n > 0) {
            this._eventType = xMLStreamReaderEx.next();
            switch (this._eventType) {
                case 1: {
                    ++n;
                    this.storeElement((XMLStreamReader)xMLStreamReaderEx);
                    break;
                }
                case 2: {
                    --n;
                    this.storeStructure(144);
                    break;
                }
                case 13: {
                    this.storeNamespaceAttributes((XMLStreamReader)xMLStreamReaderEx);
                    break;
                }
                case 10: {
                    this.storeAttributes((XMLStreamReader)xMLStreamReaderEx);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    CharSequence charSequence = xMLStreamReaderEx.getPCDATA();
                    if (charSequence instanceof Base64Data) {
                        this.storeStructure(92);
                        this.storeContentObject(charSequence);
                        break;
                    }
                    this.storeContentCharacters(80, xMLStreamReaderEx.getTextCharacters(), xMLStreamReaderEx.getTextStart(), xMLStreamReaderEx.getTextLength());
                    break;
                }
                case 5: {
                    this.storeComment((XMLStreamReader)xMLStreamReaderEx);
                    break;
                }
                case 3: {
                    this.storeProcessingInstruction((XMLStreamReader)xMLStreamReaderEx);
                }
            }
        }
        this._eventType = xMLStreamReaderEx.next();
    }

    private void storeElementAndChildrenNoEx(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = 1;
        if (this._storeInScopeNamespacesOnElementFragment) {
            this.storeElementWithInScopeNamespaces(xMLStreamReader);
        } else {
            this.storeElement(xMLStreamReader);
        }
        while (n > 0) {
            this._eventType = xMLStreamReader.next();
            switch (this._eventType) {
                case 1: {
                    ++n;
                    this.storeElement(xMLStreamReader);
                    break;
                }
                case 2: {
                    --n;
                    this.storeStructure(144);
                    break;
                }
                case 13: {
                    this.storeNamespaceAttributes(xMLStreamReader);
                    break;
                }
                case 10: {
                    this.storeAttributes(xMLStreamReader);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.storeContentCharacters(80, xMLStreamReader.getTextCharacters(), xMLStreamReader.getTextStart(), xMLStreamReader.getTextLength());
                    break;
                }
                case 5: {
                    this.storeComment(xMLStreamReader);
                    break;
                }
                case 3: {
                    this.storeProcessingInstruction(xMLStreamReader);
                }
            }
        }
        this._eventType = xMLStreamReader.next();
    }

    private void storeElementWithInScopeNamespaces(XMLStreamReader xMLStreamReader) {
        this.storeQualifiedName(32, xMLStreamReader.getPrefix(), xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
        if (xMLStreamReader.getNamespaceCount() > 0) {
            this.storeNamespaceAttributes(xMLStreamReader);
        }
        if (xMLStreamReader.getAttributeCount() > 0) {
            this.storeAttributes(xMLStreamReader);
        }
    }

    private void storeElement(XMLStreamReader xMLStreamReader) {
        this.storeQualifiedName(32, xMLStreamReader.getPrefix(), xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
        if (xMLStreamReader.getNamespaceCount() > 0) {
            this.storeNamespaceAttributes(xMLStreamReader);
        }
        if (xMLStreamReader.getAttributeCount() > 0) {
            this.storeAttributes(xMLStreamReader);
        }
    }

    public void storeElement(String string, String string2, String string3, String[] stringArray) {
        this.storeQualifiedName(32, string3, string, string2);
        this.storeNamespaceAttributes(stringArray);
    }

    public void storeEndElement() {
        this.storeStructure(144);
    }

    private void storeNamespaceAttributes(XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getNamespaceCount();
        for (int i = 0; i < n; ++i) {
            this.storeNamespaceAttribute(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
        }
    }

    private void storeNamespaceAttributes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            this.storeNamespaceAttribute(stringArray[i], stringArray[i + 1]);
        }
    }

    private void storeAttributes(XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            this.storeAttribute(xMLStreamReader.getAttributePrefix(i), xMLStreamReader.getAttributeNamespace(i), xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeType(i), xMLStreamReader.getAttributeValue(i));
        }
    }

    private void storeComment(XMLStreamReader xMLStreamReader) {
        this.storeContentCharacters(96, xMLStreamReader.getTextCharacters(), xMLStreamReader.getTextStart(), xMLStreamReader.getTextLength());
    }

    private void storeProcessingInstruction(XMLStreamReader xMLStreamReader) {
        this.storeProcessingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
    }
}

