/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream.events;

import aavax.xml.stream.events.Characters;
import com.bea.xml.stream.events.BaseEvent;
import java.io.IOException;
import java.io.Writer;

public class CharactersEvent
extends BaseEvent
implements Characters {
    private String data;
    private boolean isCData = false;
    private boolean isSpace = false;
    private boolean isIgnorable = false;

    public CharactersEvent() {
        this.init();
    }

    public CharactersEvent(String data) {
        this.init();
        this.setData(data);
    }

    public CharactersEvent(String data, boolean isCData) {
        this.init();
        this.setData(data);
        this.isCData = isCData;
    }

    public void setSpace(boolean space) {
        this.isSpace = space;
    }

    public boolean isWhiteSpace() {
        return this.isSpace;
    }

    public boolean isIgnorableWhiteSpace() {
        return this.isIgnorable;
    }

    public void setIgnorable(boolean ignorable) {
        this.isIgnorable = ignorable;
    }

    protected void init() {
        this.setEventType(4);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean isCData() {
        return this.isCData;
    }

    public char[] getDataAsArray() {
        return this.data.toCharArray();
    }

    protected void doWriteAsEncodedUnicode(Writer writer) throws IOException {
        if (this.isCData) {
            writer.write("<![CDATA[");
            writer.write(this.getData());
            writer.write("]]>");
        } else {
            String data = this.getData();
            int len = data.length();
            if (len > 0) {
                int i;
                block8: for (i = 0; i < len; ++i) {
                    switch (data.charAt(i)) {
                        case '&': 
                        case '<': 
                        case '>': {
                            break block8;
                        }
                        default: {
                            continue block8;
                        }
                    }
                }
                if (i == len) {
                    writer.write(data);
                } else {
                    if (i > 0) {
                        writer.write(data, 0, i);
                    }
                    while (i < len) {
                        char c = data.charAt(i);
                        switch (c) {
                            case '&': {
                                writer.write("&amp;");
                                break;
                            }
                            case '<': {
                                writer.write("&lt;");
                                break;
                            }
                            case '>': {
                                writer.write("&gt;");
                                break;
                            }
                            default: {
                                writer.write(c);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

